#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSProcessActorChild = 8175,
  JSProcessActorParent = 8195,
  JSWindowActorChild = 8216,
  JSWindowActorParent = 8235,
  KeyEvent = 8255,
  KeyboardEvent = 8264,
  KeyframeEffect = 8278,
  L10nFileSource = 8293,
  L10nOverlays = 8308,
  L10nRegistry = 8321,
  LargestContentfulPaint = 8334,
  LegacyMozTCPSocket = 8357,
  Localization = 8376,
  Location = 8389,
  Lock = 8398,
  LockManager = 8403,
  MIDIAccess = 8415,
  MIDIConnectionEvent = 8426,
  MIDIInput = 8446,
  MIDIInputMap = 8456,
  MIDIMessageEvent = 8469,
  MIDIOutput = 8486,
  MIDIOutputMap = 8497,
  MIDIPort = 8511,
  MLS = 8520,
  MLSGroupView = 8524,
  MOZ_debug = 8537,
  MatchGlob = 8547,
  MatchPattern = 8557,
  MatchPatternSet = 8570,
  MathMLElement = 8586,
  MediaCapabilities = 8600,
  MediaControlService = 8618,
  MediaController = 8638,
  MediaDeviceInfo = 8654,
  MediaDevices = 8670,
  MediaElementAudioSourceNode = 8683,
  MediaEncryptedEvent = 8711,
  MediaError = 8731,
  MediaKeyError = 8742,
  MediaKeyMessageEvent = 8756,
  MediaKeySession = 8777,
  MediaKeyStatusMap = 8793,
  MediaKeyStatusMap_Iterator = 8811,
  MediaKeySystemAccess = 8838,
  MediaKeys = 8859,
  MediaList = 8869,
  MediaMetadata = 8879,
  MediaQueryList = 8893,
  MediaQueryListEvent = 8908,
  MediaRecorder = 8928,
  MediaRecorderErrorEvent = 8942,
  MediaSession = 8966,
  MediaSource = 8979,
  MediaStream = 8991,
  MediaStreamAudioDestinationNode = 9003,
  MediaStreamAudioSourceNode = 9035,
  MediaStreamError = 9062,
  MediaStreamEvent = 9079,
  MediaStreamTrack = 9096,
  MediaStreamTrackAudioSourceNode = 9113,
  MediaStreamTrackEvent = 9145,
  MerchantValidationEvent = 9167,
  MessageBroadcaster = 9191,
  MessageChannel = 9210,
  MessageEvent = 9225,
  MessageListenerManager = 9238,
  MessagePort = 9261,
  MessageSender = 9273,
  MimeType = 9287,
  MimeTypeArray = 9296,
  MouseEvent = 9310,
  MouseScrollEvent = 9321,
  MozCanvasPrintState = 9338,
  MozDocumentMatcher = 9358,
  MozDocumentObserver = 9377,
  MozQueryInterface = 9397,
  MozSharedMap = 9415,
  MozSharedMap_Iterator = 9428,
  MozSharedMapChangeEvent = 9450,
  MozStorageAsyncStatementParams = 9474,
  MozStorageStatementParams = 9505,
  MozStorageStatementRow = 9531,
  MozWritableSharedMap = 9554,
  MutationObserver = 9575,
  MutationRecord = 9592,
  NamedNodeMap = 9607,
  NavigateEvent = 9620,
  Navigation = 9634,
  NavigationActivation = 9645,
  NavigationCurrentEntryChangeEvent = 9666,
  NavigationDestination = 9700,
  NavigationHistoryEntry = 9722,
  NavigationPrecommitController = 9745,
  NavigationPreloadManager = 9775,
  NavigationTransition = 9800,
  Navigator = 9821,
  NavigatorLogin = 9831,
  NetworkInformation = 9846,
  Node = 9865,
  NodeFilter = 9870,
  NodeIterator = 9881,
  NodeList = 9894,
  Notification = 9903,
  NotificationEvent = 9916,
  NotifyPaintEvent = 9934,
  OES_draw_buffers_indexed = 9951,
  OES_element_index_uint = 9976,
  OES_fbo_render_mipmap = 9999,
  OES_standard_derivatives = 10021,
  OES_texture_float = 10046,
  OES_texture_float_linear = 10064,
  OES_texture_half_float = 10089,
  OES_texture_half_float_linear = 10112,
  OES_vertex_array_object = 10142,
  OVR_multiview2 = 10166,
  OfflineAudioCompletionEvent = 10181,
  OfflineAudioContext = 10209,
  OffscreenCanvas = 10229,
  OffscreenCanvasRenderingContext2D = 10245,
  Option = 10279,
  OscillatorNode = 10286,
  PageTransitionEvent = 10301,
  PaintRequest = 10321,
  PaintRequestList = 10334,
  PaintWorkletGlobalScope = 10351,
  PannerNode = 10375,
  ParentProcessMessageManager = 10386,
  Path2D = 10414,
  PathUtils = 10421,
  PaymentAddress = 10431,
  PaymentMethodChangeEvent = 10446,
  PaymentRequest = 10471,
  PaymentRequestUpdateEvent = 10486,
  PaymentResponse = 10512,
  PeerConnectionImpl = 10528,
  PeerConnectionObserver = 10547,
  Performance = 10570,
  PerformanceEntry = 10582,
  PerformanceEntryEvent = 10599,
  PerformanceEventTiming = 10621,
  PerformanceMark = 10644,
  PerformanceMeasure = 10660,
  PerformanceNavigation = 10679,
  PerformanceNavigationTiming = 10701,
  PerformanceObserver = 10729,
  PerformanceObserverEntryList = 10749,
  PerformancePaintTiming = 10778,
  PerformanceResourceTiming = 10801,
  PerformanceServerTiming = 10827,
  PerformanceTiming = 10851,
  PeriodicWave = 10869,
  PermissionStatus = 10882,
  Permissions = 10899,
  PlacesBookmark = 10911,
  PlacesBookmarkAddition = 10926,
  PlacesBookmarkChanged = 10949,
  PlacesBookmarkGuid = 10971,
  PlacesBookmarkKeyword = 10990,
  PlacesBookmarkMoved = 11012,
  PlacesBookmarkRemoved = 11032,
  PlacesBookmarkTags = 11054,
  PlacesBookmarkTime = 11073,
  PlacesBookmarkTitle = 11092,
  PlacesBookmarkUrl = 11112,
  PlacesEvent = 11130,
  PlacesEventCounts = 11142,
  PlacesFavicon = 11160,
  PlacesHistoryCleared = 11174,
  PlacesObservers = 11195,
  PlacesPurgeCaches = 11211,
  PlacesRanking = 11229,
  PlacesVisit = 11243,
  PlacesVisitRemoved = 11255,
  PlacesVisitTitle = 11274,
  PlacesWeakCallbackWrapper = 11291,
  Plugin = 11317,
  PluginArray = 11324,
  PluginCrashedEvent = 11336,
  PointerEvent = 11355,
  PopStateEvent = 11368,
  PopupBlockedEvent = 11382,
  PopupPositionedEvent = 11400,
  PositionStateEvent = 11421,
  PrecompiledScript = 11440,
  PrivateAttribution = 11458,
  ProcessMessageManager = 11477,
  ProcessingInstruction = 11499,
  ProgressEvent = 11521,
  PromiseDebugging = 11535,
  PromiseNativeHandler = 11552,
  PromiseRejectionEvent = 11573,
  PublicKeyCredential = 11595,
  PushEvent = 11615,
  PushManager = 11625,
  PushManagerImpl = 11637,
  PushMessageData = 11653,
  PushSubscription = 11669,
  PushSubscriptionChangeEvent = 11686,
  PushSubscriptionOptions = 11714,
  RTCCertificate = 11738,
  RTCDTMFSender = 11753,
  RTCDTMFToneChangeEvent = 11767,
  RTCDataChannel = 11790,
  RTCDataChannelEvent = 11805,
  RTCDtlsTransport = 11825,
  RTCEncodedAudioFrame = 11842,
  RTCEncodedVideoFrame = 11863,
  RTCIceCandidate = 11884,
  RTCIceTransport = 11900,
  RTCIdentityProviderRegistrar = 11916,
  RTCPeerConnection = 11945,
  RTCPeerConnectionIceEvent = 11963,
  RTCPeerConnectionStatic = 11989,
  RTCRtpReceiver = 12013,
  RTCRtpScriptTransform = 12028,
  RTCRtpScriptTransformer = 12050,
  RTCRtpSender = 12074,
  RTCRtpTransceiver = 12087,
  RTCSctpTransport = 12105,
  RTCSessionDescription = 12122,
  RTCStatsReport = 12144,
  RTCTrackEvent = 12159,
  RTCTransformEvent = 12173,
  RadioNodeList = 12191,
  Range = 12205,
  ReadableByteStreamController = 12211,
  ReadableStream = 12240,
  ReadableStream_AsyncIterator = 12255,
  ReadableStreamBYOBReader = 12284,
  ReadableStreamBYOBRequest = 12309,
  ReadableStreamDefaultController = 12335,
  ReadableStreamDefaultReader = 12367,
  RedirectBlockedEvent = 12395,
  Report = 12416,
  ReportBody = 12423,
  ReportingObserver = 12434,
  Request = 12452,
  ResizeObserver = 12460,
  ResizeObserverEntry = 12475,
  ResizeObserverSize = 12495,
  Response = 12514,
  SVGAElement = 12523,
  SVGAngle = 12535,
  SVGAnimateElement = 12544,
  SVGAnimateMotionElement = 12562,
  SVGAnimateTransformElement = 12586,
  SVGAnimatedAngle = 12613,
  SVGAnimatedBoolean = 12630,
  SVGAnimatedEnumeration = 12649,
  SVGAnimatedInteger = 12672,
  SVGAnimatedLength = 12691,
  SVGAnimatedLengthList = 12709,
  SVGAnimatedNumber = 12731,
  SVGAnimatedNumberList = 12749,
  SVGAnimatedPreserveAspectRatio = 12771,
  SVGAnimatedRect = 12802,
  SVGAnimatedString = 12818,
  SVGAnimatedTransformList = 12836,
  SVGAnimationElement = 12861,
  SVGCircleElement = 12881,
  SVGClipPathElement = 12898,
  SVGComponentTransferFunctionElement = 12917,
  SVGDefsElement = 12953,
  SVGDescElement = 12968,
  SVGElement = 12983,
  SVGEllipseElement = 12994,
  SVGFEBlendElement = 13012,
  SVGFEColorMatrixElement = 13030,
  SVGFEComponentTransferElement = 13054,
  SVGFECompositeElement = 13084,
  SVGFEConvolveMatrixElement = 13106,
  SVGFEDiffuseLightingElement = 13133,
  SVGFEDisplacementMapElement = 13161,
  SVGFEDistantLightElement = 13189,
  SVGFEDropShadowElement = 13214,
  SVGFEFloodElement = 13237,
  SVGFEFuncAElement = 13255,
  SVGFEFuncBElement = 13273,
  SVGFEFuncGElement = 13291,
  SVGFEFuncRElement = 13309,
  SVGFEGaussianBlurElement = 13327,
  SVGFEImageElement = 13352,
  SVGFEMergeElement = 13370,
  SVGFEMergeNodeElement = 13388,
  SVGFEMorphologyElement = 13410,
  SVGFEOffsetElement = 13433,
  SVGFEPointLightElement = 13452,
  SVGFESpecularLightingElement = 13475,
  SVGFESpotLightElement = 13504,
  SVGFETileElement = 13526,
  SVGFETurbulenceElement = 13543,
  SVGFilterElement = 13566,
  SVGForeignObjectElement = 13583,
  SVGGElement = 13607,
  SVGGeometryElement = 13619,
  SVGGradientElement = 13638,
  SVGGraphicsElement = 13657,
  SVGImageElement = 13676,
  SVGLength = 13692,
  SVGLengthList = 13702,
  SVGLineElement = 13716,
  SVGLinearGradientElement = 13731,
  SVGMPathElement = 13756,
  SVGMarkerElement = 13772,
  SVGMaskElement = 13789,
  SVGMatrix = 13804,
  SVGMetadataElement = 13814,
  SVGNumber = 13833,
  SVGNumberList = 13843,
  SVGPathElement = 13857,
  SVGPathSegment = 13872,
  SVGPatternElement = 13887,
  SVGPoint = 13905,
  SVGPointList = 13914,
  SVGPolygonElement = 13927,
  SVGPolylineElement = 13945,
  SVGPreserveAspectRatio = 13964,
  SVGRadialGradientElement = 13987,
  SVGRect = 14012,
  SVGRectElement = 14020,
  SVGSVGElement = 14035,
  SVGScriptElement = 14049,
  SVGSetElement = 14066,
  SVGStopElement = 14080,
  SVGStringList = 14095,
  SVGStyleElement = 14109,
  SVGSwitchElement = 14125,
  SVGSymbolElement = 14142,
  SVGTSpanElement = 14159,
  SVGTextContentElement = 14175,
  SVGTextElement = 14197,
  SVGTextPathElement = 14212,
  SVGTextPositioningElement = 14231,
  SVGTitleElement = 14257,
  SVGTransform = 14273,
  SVGTransformList = 14286,
  SVGUnitTypes = 14303,
  SVGUseElement = 14316,
  SVGViewElement = 14330,
  Sanitizer = 14345,
  Scheduler = 14355,
  Screen = 14365,
  ScreenLuminance = 14372,
  ScreenOrientation = 14388,
  ScriptProcessorNode = 14406,
  ScrollAreaEvent = 14426,
  SecurityPolicyViolationEvent = 14442,
  Selection = 14471,
  ServiceWorker = 14481,
  ServiceWorkerContainer = 14495,
  ServiceWorkerGlobalScope = 14518,
  ServiceWorkerRegistration = 14543,
  SessionStoreFormData = 14569,
  SessionStoreScrollData = 14590,
  SessionStoreUtils = 14613,
  ShadowRealmGlobalScope = 14631,
  ShadowRoot = 14654,
  SharedWorker = 14665,
  SharedWorkerGlobalScope = 14678,
  SimpleGestureEvent = 14702,
  SourceBuffer = 14721,
  SourceBufferList = 14734,
  SpeechGrammar = 14751,
  SpeechGrammarList = 14765,
  SpeechRecognition = 14783,
  SpeechRecognitionAlternative = 14801,
  SpeechRecognitionError = 14830,
  SpeechRecognitionEvent = 14853,
  SpeechRecognitionResult = 14876,
  SpeechRecognitionResultList = 14900,
  SpeechSynthesis = 14928,
  SpeechSynthesisErrorEvent = 14944,
  SpeechSynthesisEvent = 14970,
  SpeechSynthesisUtterance = 14991,
  SpeechSynthesisVoice = 15016,
  StaticRange = 15037,
  StereoPannerNode = 15049,
  Storage = 15066,
  StorageEvent = 15074,
  StorageManager = 15087,
  StreamFilter = 15102,
  StreamFilterDataEvent = 15115,
  StructuredCloneHolder = 15137,
  StructuredCloneTester = 15159,
  StylePropertyMap = 15181,
  StylePropertyMapReadOnly = 15198,
  StylePropertyMapReadOnly_Iterator = 15223,
  StyleSheet = 15257,
  StyleSheetApplicableStateChangeEvent = 15268,
  StyleSheetList = 15305,
  StyleSheetRemovedEvent = 15320,
  SubmitEvent = 15343,
  SubtleCrypto = 15355,
  SyncMessageSender = 15368,
  SyncReadFile = 15386,
  TCPServerSocket = 15399,
  TCPServerSocketEvent = 15415,
  TCPSocket = 15436,
  TCPSocketErrorEvent = 15446,
  TCPSocketEvent = 15466,
  TaskController = 15481,
  TaskPriorityChangeEvent = 15496,
  TaskSignal = 15520,
  Tensor = 15531,
  TestUtils = 15538,
  TestingDeprecatedInterface = 15548,
  Text = 15575,
  TextClause = 15580,
  TextDecoder = 15591,
  TextDecoderStream = 15603,
  TextEncoder = 15621,
  TextEncoderStream = 15633,
  TextEvent = 15651,
  TextMetrics = 15661,
  TextTrack = 15673,
  TextTrackCue = 15683,
  TextTrackCueList = 15696,
  TextTrackList = 15713,
  TimeEvent = 15727,
  TimeRanges = 15737,
  ToggleEvent = 15748,
  Touch = 15760,
  TouchEvent = 15766,
  TouchList = 15777,
  TrackEvent = 15787,
  TransformStream = 15798,
  TransformStreamDefaultController = 15814,
  TransitionEvent = 15847,
  TreeColumn = 15863,
  TreeColumns = 15874,
  TreeContentView = 15886,
  TreeWalker = 15902,
  TrustedHTML = 15913,
  TrustedScript = 15925,
  TrustedScriptURL = 15939,
  TrustedTypePolicy = 15956,
  TrustedTypePolicyFactory = 15974,
  UDPMessageEvent = 15999,
  UDPSocket = 16015,
  UIEvent = 16025,
  URL = 16033,
  URLPattern = 16037,
  URLSearchParams = 16048,
  URLSearchParams_Iterator = 16064,
  UniFFIPointer = 16089,
  UniFFIScaffolding = 16103,
  UserActivation = 16121,
  UserInteraction = 16136,
  UserProximityEvent = 16152,
  VRDisplay = 16171,
  VRDisplayCapabilities = 16181,
  VRDisplayEvent = 16203,
  VREyeParameters = 16218,
  VRFieldOfView = 16234,
  VRFrameData = 16248,
  VRMockController = 16260,
  VRMockDisplay = 16277,
  VRPose = 16291,
  VRServiceTest = 16298,
  VRStageParameters = 16312,
  VTTCue = 16330,
  VTTRegion = 16337,
  ValidityState = 16347,
  VideoColorSpace = 16361,
  VideoDecoder = 16377,
  VideoEncoder = 16390,
  VideoFrame = 16403,
  VideoPlaybackQuality = 16414,
  VideoTrack = 16435,
  VideoTrackList = 16446,
  ViewTransition = 16461,
  VisualViewport = 16476,
  WEBGL_color_buffer_float = 16491,
  WEBGL_compressed_texture_astc = 16516,
  WEBGL_compressed_texture_etc = 16546,
  WEBGL_compressed_texture_etc1 = 16575,
  WEBGL_compressed_texture_pvrtc = 16605,
  WEBGL_compressed_texture_s3tc = 16636,
  WEBGL_compressed_texture_s3tc_srgb = 16666,
  WEBGL_debug_renderer_info = 16701,
  WEBGL_debug_shaders = 16727,
  WEBGL_depth_texture = 16747,
  WEBGL_draw_buffers = 16767,
  WEBGL_explicit_present = 16786,
  WEBGL_lose_context = 16809,
  WEBGL_provoking_vertex = 16828,
  WGSLLanguageFeatures = 16851,
  WakeLock = 16872,
  WakeLockSentinel = 16881,
  WaveShaperNode = 16898,
  WebExtensionContentScript = 16913,
  WebExtensionPolicy = 16939,
  WebGL2RenderingContext = 16958,
  WebGLActiveInfo = 16981,
  WebGLBuffer = 16997,
  WebGLContextEvent = 17009,
  WebGLFramebuffer = 17027,
  WebGLProgram = 17044,
  WebGLQuery = 17057,
  WebGLRenderbuffer = 17068,
  WebGLRenderingContext = 17086,
  WebGLSampler = 17108,
  WebGLShader = 17121,
  WebGLShaderPrecisionFormat = 17133,
  WebGLSync = 17160,
  WebGLTexture = 17170,
  WebGLTransformFeedback = 17183,
  WebGLUniformLocation = 17206,
  WebGLVertexArrayObject = 17227,
  WebKitCSSMatrix = 17250,
  WebSocket = 17266,
  WebTransport = 17276,
  WebTransportBidirectionalStream = 17289,
  WebTransportDatagramDuplexStream = 17321,
  WebTransportError = 17354,
  WebTransportReceiveStream = 17372,
  WebTransportSendStream = 17398,
  WebrtcGlobalInformation = 17421,
  WheelEvent = 17445,
  Window = 17456,
  WindowClient = 17463,
  WindowContext = 17476,
  WindowGlobalChild = 17490,
  WindowGlobalParent = 17508,
  WindowRoot = 17527,
  Worker = 17538,
  WorkerDebuggerGlobalScope = 17545,
  WorkerGlobalScope = 17571,
  WorkerLocation = 17589,
  WorkerNavigator = 17604,
  WorkerTestUtils = 17620,
  Worklet = 17636,
  WorkletGlobalScope = 17644,
  WritableStream = 17663,
  WritableStreamDefaultController = 17678,
  WritableStreamDefaultWriter = 17710,
  XMLDocument = 17738,
  XMLHttpRequest = 17750,
  XMLHttpRequestEventTarget = 17765,
  XMLHttpRequestUpload = 17791,
  XMLSerializer = 17812,
  XPathEvaluator = 17826,
  XPathExpression = 17841,
  XPathResult = 17857,
  XRBoundedReferenceSpace = 17869,
  XRFrame = 17893,
  XRInputSource = 17901,
  XRInputSourceArray = 17915,
  XRInputSourceEvent = 17934,
  XRInputSourcesChangeEvent = 17953,
  XRPose = 17979,
  XRReferenceSpace = 17986,
  XRReferenceSpaceEvent = 18003,
  XRRenderState = 18025,
  XRRigidTransform = 18039,
  XRSession = 18056,
  XRSessionEvent = 18066,
  XRSpace = 18081,
  XRSystem = 18089,
  XRView = 18098,
  XRViewerPose = 18105,
  XRViewport = 18118,
  XRWebGLLayer = 18129,
  XSLTProcessor = 18142,
  XULCommandEvent = 18156,
  XULElement = 18172,
  XULFrameElement = 18183,
  XULMenuElement = 18199,
  XULPopupElement = 18214,
  XULResizerElement = 18230,
  XULTextElement = 18248,
  XULTreeElement = 18263,
  console = 18278,
  webkitSpeechGrammar = 18286,
  webkitSpeechGrammarList = 18306,
  webkitSpeechRecognition = 18330,
  webkitURL = 18354,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
