// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanScreenshotsMetrics_h
#define mozilla_GleanScreenshotsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace screenshots {
  /**
   * generated from screenshots.canceled_context_menu
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#context_menu.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_context_menu(707);

  /**
   * generated from screenshots.canceled_escape
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#escape.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_escape(708);

  /**
   * generated from screenshots.canceled_navigation
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#navigation.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_navigation(709);

  /**
   * generated from screenshots.canceled_overlay_cancel
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#overlay_cancel.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_overlay_cancel(710);

  /**
   * generated from screenshots.canceled_preview_cancel
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#preview_cancel.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_preview_cancel(711);

  /**
   * generated from screenshots.canceled_quick_actions
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#quick_actions.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_quick_actions(712);

  /**
   * generated from screenshots.canceled_shortcut
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#shortcut.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_shortcut(713);

  /**
   * generated from screenshots.canceled_toolbar_button
   */
  /**
   * Recorded when a user closes the screenshots ui. The screenshots ui is closed after copying/downloading but we do not record that as canceling the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.canceled#toolbar_button.
   */
  constexpr impl::EventMetric<NoExtraKeys> canceled_toolbar_button(714);

  /**
   * generated from screenshots.copy_overlay_copy
   */
  struct CopyOverlayCopyExtra {
    mozilla::Maybe<nsCString> element;
    mozilla::Maybe<nsCString> fullpage;
    mozilla::Maybe<nsCString> move;
    mozilla::Maybe<nsCString> region;
    mozilla::Maybe<nsCString> resize;
    mozilla::Maybe<nsCString> visible;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (element) {
        extraKeys.AppendElement()->AssignASCII("element");
        extraValues.EmplaceBack(element.value());
      }
      if (fullpage) {
        extraKeys.AppendElement()->AssignASCII("fullpage");
        extraValues.EmplaceBack(fullpage.value());
      }
      if (move) {
        extraKeys.AppendElement()->AssignASCII("move");
        extraValues.EmplaceBack(move.value());
      }
      if (region) {
        extraKeys.AppendElement()->AssignASCII("region");
        extraValues.EmplaceBack(region.value());
      }
      if (resize) {
        extraKeys.AppendElement()->AssignASCII("resize");
        extraValues.EmplaceBack(resize.value());
      }
      if (visible) {
        extraKeys.AppendElement()->AssignASCII("visible");
        extraValues.EmplaceBack(visible.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user copies a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.copy#overlay_copy.
   */
  constexpr impl::EventMetric<CopyOverlayCopyExtra> copy_overlay_copy(715);

  /**
   * generated from screenshots.copy_preview_copy
   */
  struct CopyPreviewCopyExtra {
    mozilla::Maybe<nsCString> element;
    mozilla::Maybe<nsCString> fullpage;
    mozilla::Maybe<nsCString> move;
    mozilla::Maybe<nsCString> region;
    mozilla::Maybe<nsCString> resize;
    mozilla::Maybe<nsCString> visible;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (element) {
        extraKeys.AppendElement()->AssignASCII("element");
        extraValues.EmplaceBack(element.value());
      }
      if (fullpage) {
        extraKeys.AppendElement()->AssignASCII("fullpage");
        extraValues.EmplaceBack(fullpage.value());
      }
      if (move) {
        extraKeys.AppendElement()->AssignASCII("move");
        extraValues.EmplaceBack(move.value());
      }
      if (region) {
        extraKeys.AppendElement()->AssignASCII("region");
        extraValues.EmplaceBack(region.value());
      }
      if (resize) {
        extraKeys.AppendElement()->AssignASCII("resize");
        extraValues.EmplaceBack(resize.value());
      }
      if (visible) {
        extraKeys.AppendElement()->AssignASCII("visible");
        extraValues.EmplaceBack(visible.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user copies a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.copy#preview_copy.
   */
  constexpr impl::EventMetric<CopyPreviewCopyExtra> copy_preview_copy(716);

  /**
   * generated from screenshots.download_overlay_download
   */
  struct DownloadOverlayDownloadExtra {
    mozilla::Maybe<nsCString> element;
    mozilla::Maybe<nsCString> fullpage;
    mozilla::Maybe<nsCString> move;
    mozilla::Maybe<nsCString> region;
    mozilla::Maybe<nsCString> resize;
    mozilla::Maybe<nsCString> visible;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (element) {
        extraKeys.AppendElement()->AssignASCII("element");
        extraValues.EmplaceBack(element.value());
      }
      if (fullpage) {
        extraKeys.AppendElement()->AssignASCII("fullpage");
        extraValues.EmplaceBack(fullpage.value());
      }
      if (move) {
        extraKeys.AppendElement()->AssignASCII("move");
        extraValues.EmplaceBack(move.value());
      }
      if (region) {
        extraKeys.AppendElement()->AssignASCII("region");
        extraValues.EmplaceBack(region.value());
      }
      if (resize) {
        extraKeys.AppendElement()->AssignASCII("resize");
        extraValues.EmplaceBack(resize.value());
      }
      if (visible) {
        extraKeys.AppendElement()->AssignASCII("visible");
        extraValues.EmplaceBack(visible.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user downloads a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.download#overlay_download.
   */
  constexpr impl::EventMetric<DownloadOverlayDownloadExtra> download_overlay_download(717);

  /**
   * generated from screenshots.download_preview_download
   */
  struct DownloadPreviewDownloadExtra {
    mozilla::Maybe<nsCString> element;
    mozilla::Maybe<nsCString> fullpage;
    mozilla::Maybe<nsCString> move;
    mozilla::Maybe<nsCString> region;
    mozilla::Maybe<nsCString> resize;
    mozilla::Maybe<nsCString> visible;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (element) {
        extraKeys.AppendElement()->AssignASCII("element");
        extraValues.EmplaceBack(element.value());
      }
      if (fullpage) {
        extraKeys.AppendElement()->AssignASCII("fullpage");
        extraValues.EmplaceBack(fullpage.value());
      }
      if (move) {
        extraKeys.AppendElement()->AssignASCII("move");
        extraValues.EmplaceBack(move.value());
      }
      if (region) {
        extraKeys.AppendElement()->AssignASCII("region");
        extraValues.EmplaceBack(region.value());
      }
      if (resize) {
        extraKeys.AppendElement()->AssignASCII("resize");
        extraValues.EmplaceBack(resize.value());
      }
      if (visible) {
        extraKeys.AppendElement()->AssignASCII("visible");
        extraValues.EmplaceBack(visible.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user downloads a screenshot from the overlay or the preview. This event was generated to correspond to the Legacy Telemetry event screenshots.download#preview_download.
   */
  constexpr impl::EventMetric<DownloadPreviewDownloadExtra> download_preview_download(718);

  /**
   * generated from screenshots.failed_screenshot_too_large
   */
  /**
   * Recorded when a screenshot is too big to capture and we have to crop the screenshot. This event was generated to correspond to the Legacy Telemetry event screenshots.failed#screenshot_too_large.
   */
  constexpr impl::EventMetric<NoExtraKeys> failed_screenshot_too_large(719);

  /**
   * generated from screenshots.selected_element
   */
  /**
   * Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#element.
   */
  constexpr impl::EventMetric<NoExtraKeys> selected_element(720);

  /**
   * generated from screenshots.selected_full_page
   */
  /**
   * Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#full_page.
   */
  constexpr impl::EventMetric<NoExtraKeys> selected_full_page(721);

  /**
   * generated from screenshots.selected_region_selection
   */
  /**
   * Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#region_selection.
   */
  constexpr impl::EventMetric<NoExtraKeys> selected_region_selection(722);

  /**
   * generated from screenshots.selected_visible
   */
  /**
   * Recorded when a user selects a region by hand, selects an element, selects the save visible, or selects save full page. Note that this is recorded independent of whether or not the screenshot is saved. This event was generated to correspond to the Legacy Telemetry event screenshots.selected#visible.
   */
  constexpr impl::EventMetric<NoExtraKeys> selected_visible(723);

  /**
   * generated from screenshots.started_context_menu
   */
  /**
   * Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#context_menu.
   */
  constexpr impl::EventMetric<NoExtraKeys> started_context_menu(724);

  /**
   * generated from screenshots.started_overlay_retry
   */
  /**
   * Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#overlay_retry.
   */
  constexpr impl::EventMetric<NoExtraKeys> started_overlay_retry(725);

  /**
   * generated from screenshots.started_preview_retry
   */
  /**
   * Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#preview_retry.
   */
  constexpr impl::EventMetric<NoExtraKeys> started_preview_retry(726);

  /**
   * generated from screenshots.started_quick_actions
   */
  /**
   * Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#quick_actions.
   */
  constexpr impl::EventMetric<NoExtraKeys> started_quick_actions(727);

  /**
   * generated from screenshots.started_shortcut
   */
  /**
   * Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#shortcut.
   */
  constexpr impl::EventMetric<NoExtraKeys> started_shortcut(728);

  /**
   * generated from screenshots.started_toolbar_button
   */
  /**
   * Recorded when a user opens the screenshots ui. This event was generated to correspond to the Legacy Telemetry event screenshots.started#toolbar_button.
   */
  constexpr impl::EventMetric<NoExtraKeys> started_toolbar_button(729);
}

} // namespace mozilla::glean

#endif // mozilla_GleanScreenshotsMetrics_h
