/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.torproject.metrics.descriptorparser.utils.FormattingUtils;
import org.torproject.metrics.descriptorparser.utils.RdnsLookupWorker;

public class ReverseDomainNameResolver {
    static final long RDNS_LOOKUP_MAX_REQUEST_MILLIS = 10000L;
    static final long RDNS_LOOKUP_MAX_DURATION_MILLIS = 300000L;
    private static final long RDNS_LOOKUP_MAX_AGE_MILLIS = 43200000L;
    private static final int RDNS_LOOKUP_WORKERS_NUM = 30;
    private Map<String, Long> addressLastLookupTimes;
    Set<String> rdnsLookupJobs;
    Map<String, SortedSet<String>> rdnsVerifiedLookupResults;
    Map<String, SortedSet<String>> rdnsUnverifiedLookupResults;
    List<Long> rdnsLookupMillis;
    long startedRdnsLookups;
    private List<RdnsLookupWorker> rdnsLookupWorkers;

    public void setAddresses(Map<String, Long> addressLastLookupTimes) {
        this.addressLastLookupTimes = addressLastLookupTimes;
    }

    public void startReverseDomainNameLookups() {
        this.startedRdnsLookups = System.currentTimeMillis();
        this.rdnsLookupJobs = new HashSet<String>();
        for (Map.Entry<String, Long> e : this.addressLastLookupTimes.entrySet()) {
            if (e.getValue() >= this.startedRdnsLookups - 43200000L) continue;
            this.rdnsLookupJobs.add(e.getKey());
        }
        this.rdnsVerifiedLookupResults = new HashMap<String, SortedSet<String>>();
        this.rdnsUnverifiedLookupResults = new HashMap<String, SortedSet<String>>();
        this.rdnsLookupMillis = new ArrayList<Long>();
        this.rdnsLookupWorkers = new ArrayList<RdnsLookupWorker>();
        for (int i = 0; i < 30; ++i) {
            RdnsLookupWorker rdnsLookupWorker = new RdnsLookupWorker(this);
            this.rdnsLookupWorkers.add(rdnsLookupWorker);
            rdnsLookupWorker.setDaemon(true);
            rdnsLookupWorker.start();
        }
    }

    public void finishReverseDomainNameLookups() {
        for (RdnsLookupWorker rdnsLookupWorker : this.rdnsLookupWorkers) {
            try {
                rdnsLookupWorker.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SortedSet<String>> getVerifiedLookupResults() {
        Map<String, SortedSet<String>> map = this.rdnsVerifiedLookupResults;
        synchronized (map) {
            return new HashMap<String, SortedSet<String>>(this.rdnsVerifiedLookupResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SortedSet<String>> getUnverifiedLookupResults() {
        Map<String, SortedSet<String>> map = this.rdnsUnverifiedLookupResults;
        synchronized (map) {
            return new HashMap<String, SortedSet<String>>(this.rdnsUnverifiedLookupResults);
        }
    }

    public long getLookupStartMillis() {
        return this.startedRdnsLookups;
    }

    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.rdnsLookupMillis.size())).append(" lookups performed\n");
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.rdnsVerifiedLookupResults.size())).append(" verified results found\n");
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.rdnsUnverifiedLookupResults.size())).append(" unverified results found\n");
        if (!this.rdnsLookupMillis.isEmpty()) {
            Collections.sort(this.rdnsLookupMillis);
            sb.append("    ").append(FormattingUtils.formatMillis(this.rdnsLookupMillis.get(0))).append(" minimum lookup time\n");
            sb.append("    ").append(FormattingUtils.formatMillis(this.rdnsLookupMillis.get(this.rdnsLookupMillis.size() / 2))).append(" median lookup time\n");
            sb.append("    ").append(FormattingUtils.formatMillis(this.rdnsLookupMillis.get(this.rdnsLookupMillis.size() - 1))).append(" maximum lookup time\n");
        }
        return sb.toString();
    }
}

