/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.utils;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.descriptorparser.utils.Gauge;
import org.torproject.metrics.descriptorparser.utils.VictoriaMetricsHttpConnectionFactory;

public class OpenMetricsWriter {
    private static final Logger logger = LoggerFactory.getLogger(OpenMetricsWriter.class);

    public void processNetworkTotal(Gauge inprogressRequests, Long timestamp, double value) {
        Gauge.Child child = new Gauge.Child();
        try {
            child.setTimestampMs(timestamp);
            child.set(value);
            inprogressRequests.setChild(child, new String[0]);
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }

    public void processRequest(Gauge inprogressRequests, String fingerprint, String nickname, String node, Long timestamp, double value) {
        Gauge.Child child = new Gauge.Child();
        try {
            if (node == null) {
                inprogressRequests.labels(fingerprint, nickname);
                child.setTimestampMs(timestamp);
                child.set(value);
                inprogressRequests.setChild(child, fingerprint, nickname);
            } else {
                inprogressRequests.labels(fingerprint, nickname, node);
                child.setTimestampMs(timestamp);
                child.set(value);
                inprogressRequests.setChild(child, fingerprint, nickname, node);
            }
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }

    public void processRelayReqCountry(Gauge inprogressRequests, String fingerprint, String nickname, String country, Long timestamp, double value) {
        try {
            Gauge.Child child = new Gauge.Child();
            inprogressRequests.labels(fingerprint, nickname, country);
            child.setTimestampMs(timestamp);
            child.set(value);
            inprogressRequests.setChild(child, fingerprint, nickname, country);
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }

    public void processRouterLabelmetrics(Gauge inprogressRequests, String fingerprint, String nickname, String node, String country, String transport, String version, Long timestamp, double value) {
        Gauge.Child child = new Gauge.Child();
        try {
            if (node == null) {
                inprogressRequests.labels(fingerprint, nickname, country, transport, version);
                child.setTimestampMs(timestamp);
                child.set(value);
                inprogressRequests.setChild(child, fingerprint, nickname, country, transport, version);
            } else {
                inprogressRequests.labels(fingerprint, nickname, node, country, transport, version);
                child.setTimestampMs(timestamp);
                child.set(value);
                inprogressRequests.setChild(child, fingerprint, nickname, node, country, transport, version);
            }
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }

    public void pushToGateway(CollectorRegistry registry) {
        PushGateway pushgateway = new PushGateway("172.17.0.2:8428/api/v1/import/prometheus");
        try {
            pushgateway.setConnectionFactory(new VictoriaMetricsHttpConnectionFactory());
            pushgateway.pushAdd(registry, "");
        }
        catch (IOException ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }
}

