/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.parsers;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExitList;
import org.torproject.metrics.descriptorparser.utils.DescriptorUtils;

public class ExitListParser {
    private static final String INSERT_EXIT_LISTS_SQL = "INSERT INTO exit_list (downloaded, header, digest) VALUES (?, ?, ?)";
    private static final String INSERT_EXIT_NODES_SQL = "INSERT INTO exit_node (digest, published, last_status, fingerprint, exit_addresses, exit_addresses_timestamps, exit_list) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final Logger logger = LoggerFactory.getLogger(ExitListParser.class);

    public void run(String path, Connection conn) throws Exception {
        DescriptorUtils descUtils = new DescriptorUtils();
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File(path))) {
            if (!(descriptor instanceof ExitList)) continue;
            ExitList desc = (ExitList)descriptor;
            String digest = descUtils.calculateDigestSha256Base64(desc.getRawDescriptorBytes());
            this.addExitList(desc, digest, conn);
            for (ExitList.Entry exitEntry : desc.getEntries()) {
                this.addExitEntry(exitEntry, digest, conn);
            }
        }
    }

    private void addExitList(ExitList desc, String digest, Connection conn) {
        DescriptorUtils descUtils = new DescriptorUtils();
        try (PreparedStatement preparedStatement = conn.prepareStatement(INSERT_EXIT_LISTS_SQL);){
            preparedStatement.setTimestamp(1, new Timestamp(desc.getDownloadedMillis()));
            preparedStatement.setString(2, "@type tordnsel 1.0");
            preparedStatement.setString(3, digest);
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
            ex.printStackTrace();
        }
    }

    private void addExitEntry(ExitList.Entry exitEntry, String digest, Connection conn) {
        DescriptorUtils descUtils = new DescriptorUtils();
        try (PreparedStatement preparedStatement = conn.prepareStatement(INSERT_EXIT_NODES_SQL);){
            String digestLine = descUtils.fieldAsString(exitEntry);
            preparedStatement.setString(1, descUtils.calculateDigestSha256Base64(digestLine.getBytes()));
            preparedStatement.setTimestamp(2, new Timestamp(exitEntry.getPublishedMillis()));
            preparedStatement.setTimestamp(3, new Timestamp(exitEntry.getLastStatusMillis()));
            preparedStatement.setString(4, exitEntry.getFingerprint());
            ArrayList<String> addresses = new ArrayList<String>();
            ArrayList<Long> timestamps = new ArrayList<Long>();
            for (Map.Entry<String, Long> e : exitEntry.getExitAddresses().entrySet()) {
                String address = e.getKey();
                Long timestamp = e.getValue();
                addresses.add(address);
                timestamps.add(timestamp);
            }
            preparedStatement.setString(5, String.join((CharSequence)", ", addresses));
            preparedStatement.setString(6, String.join((CharSequence)", ", ((Object)timestamps).toString()));
            preparedStatement.setString(7, digest);
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
            ex.printStackTrace();
        }
    }
}

